(define (initialize-n-queens n net)
  (begin 
    (queen-names-and-domains 0 n net) 
    (queen-constraint-arcs n net)
    #f)
)

;;; The constraint function checks to see if queens can attack each
;;; other. (note that same column is ruled out because of our choice
;;; of representation,... good representation== half problem solved)
(define (queens-safe? head tail parameters)
;;THIS IS WHAT YOU HAVE TO PROVIDE
#f
)

;;; A queen is attached to a column, the domain represents the row
;;; where it is to be placed.  This already builds in constraint that
;;; queens cannot safely occupy the same column.
(define (queen-names-and-domains count n net)
  (if (= count n)
      '()
    (begin
      (constraint-network::insert-variable! net count (make-index-list n))
      (queen-names-and-domains (+ 1 count) n net))
    )
  )

;;; This produces (almost) n^2 arcs, every queen needs to check every
;;; other queen (except itself).  Recall that arcs are directional.
;;; Each constraint is equipped with two parameters; the first contains
;;; the column of the queen at one end, and the second contains the column
;;; of the queen at the other end.

(define (queen-constraint-arcs n net)
  (map (lambda (q1)
	 (map (lambda (q2)
		(if (not (= q1 q2))			; no self loops.
		    (begin 
		      (constraint-network::insert-constraint-instance! 
		       net q1 q2 "" queens-safe? `((col1 . ,q1) (col2 . ,q2)))
		      )
		    '()
		    )
		)
	      (make-index-list n)))
	 (make-index-list n))
)


(define (go-N-queens . n)
  (let ((N (if (null? n)
	       8
	       (car n)
	       )
	   )
	(queen-net (new-constraint-network))
	)
  
  (begin
    (initialize-n-queens N queen-net)
    ;;(propagate-constraints! *propagate-constraints-strategy::full* queen-net)
    ;;(constraint-search *constraint-search-strategy::full/all* course-net)
    (constraint-search *constraint-search-strategy::full* queen-net)
  )
)
)
