;; A required course is a list of:
;; - name (symbol)
;; - 'fall, 'spring, 'any
;; - one or more course names of prerequisities
;;
;; A *course-requirements* list is a list of courses that must be completed
;; for graduation. The goal of the constraint package is to produce a
;; term and slot number for every required course such that prerequisites,
;; constraints on offering times, graduation term limit and max number of
;; simultaneous classes are all respected.
;;
;; Each course gets assigned to a (*term* . *slot*) pair, where a
;; *term* is a number from 1-*max-terms* and a *slot* is a number from
;; 1-*max-simultaneous-classes*.  No two courses may occupy the same
;; (*term* . *slot*) pair.
;; 
;; odd terms are considered fall terms, and even terms are considered spring
;; terms.
;;
;; Domains for course variables should be generated in dictionary
;; ordering - highest priority on term number, in ascending order,
;; followed by slot number to break ties. For example, the domain for
;; <8.01> from the baby example (from the public test cases) should
;; look like: (1 . 1) (1 . 2)
;;
;; Also note that variables must be added to your constraint network
;; in the order they appear in course-requirements. With the given
;; search strategies being used, this is important, as their exact
;; output is order dependent. (The same sets are found, but if they
;; are not in the correct order, you may fool the automated grader into
;; thinking you got the problem wrong.)

;;These two procedures may prove useful during testing

(define (same-set? l1 l2)
  (and (for-all? l1 (lambda (elt)
		      (member elt l2))
		 )
       (for-all? l2 (lambda (elt)
		      (member elt l1))
		 )
       )
  )

(define (same-set-of-sets? l1 l2)
  (and (for-all? l1 (lambda (elt)
		      (there-exists? l2 (lambda (elt2)
					  (same-set? elt elt2))
				     )
		      )
		 )
       (for-all? l1 (lambda (elt)
		      (there-exists? l2 (lambda (elt2)
					  (same-set? elt elt2))
				     )
		      )
		 )
       )
  )

(define (get-normal-ordering lst)
  (sort lst (lambda (a b)
              (string<? (symbol->string a) (symbol->string b)))))

;;The outline this solution follows is roughly:
;;
;; - First instantiate a variable for each course with the appropriate
;;   domain
;;
;;   - You may want to write something like (list-upto-n n) which returns
;;     the list of numbers 1..n and/or (cross-product l1 l2) which returns
;;     the cartesian product of the two sets (to generate domains)
;;
;; - Add constraints for prerequisites: for each couse, add a constraint for
;;   each of its prerequisites (map a simple procedure onto each one)
;;

(define (create-prereqs-constraint-net course-requirements
				       max-terms
				       max-simultaneous-classes
				       )
  (let* ((net (new-constraint-network))
	 )
    (map (lambda (course)
	   (instantiate-course-variable net course max-terms max-simultaneous-classes)
	   )
	 course-requirements)
    (display "Added course variables!\n")
    (map (lambda (course)
	   (instantiate-prereq-constraints net course)
	   )
	 course-requirements)
    (display "Instantiated prereqs!\n")
    (display "Ready to rock.\n")
    net
    )
  )



(define (instantiate-prereq-constraints net course)
  ;; TODO: Implement this
  #f
  )

(define (instantiate-course-variable net course max-terms max-sim-class)
  ;; TODO: Implement this
  #f
)


(define (create-schedule-constraint-net course-reqs max-terms max-sim-class)
  (let ((prereq-net (create-prereqs-constraint-net course-reqs max-terms max-sim-class)
		    )
	)
    ;; TODO: Add in code to prevent taking more than max-sim-classes
    ;; simultaneously here.
    (display "Really ready to rock.\n")
    prereq-net
    )
  )

(define (generate-prereqsonly-graduation-plan course-reqs max-terms max-sim-class all?)
  (constraint-search (if all?
			 *constraint-search-strategy::full/all*
			 *constraint-search-strategy::full*
			 )
		     (create-prereqs-constraint-net course-reqs
						     max-terms
						     max-sim-class)
		     )
  )

(define (generate-graduation-plan course-reqs max-terms max-sim-class all?)
  (constraint-search (if all?
			 *constraint-search-strategy::full/all*
			 *constraint-search-strategy::full*
			 )
		     (create-schedule-constraint-net course-reqs
						     max-terms
						     max-sim-class)
		     )
  )

(define baby-courses
  '((<8.01> fall)
    (<18.01> fall)
    (<18.02> spring <18.01>)
    (<8.02> spring <8.01> <18.01>)
    )
  )

(define some-girs
  '((<7.012> any)
    (<5.111> any)
    (HASS-1 any)
    )
  )

;; You are highly encouraged to check complicated cases like the one
;; below, as the hidden test cases are likely to involve them.

(define cs-the-right-way
  (append baby-courses
	  '((<18.03> any <18.02>)
	    (hatred-of-everything any <18.03>)
	    (<18.100B> any hatred-of-everything)
	    (<6.001> any)
	    (<6.002> any <18.03> <8.02>)
	    (<6.003> any <6.002>)
	    (<6.004> any <6.002>)
	    (<6.034> fall <6.001>)
	    (<6.046> any <18.100B>)
	    (<6.033> spring <6.004>)
	    (total-enlightenment any <18.100B>)
	    )
	  )
  )

