(if (not (eq? #f '()))
    (begin
      (pp "You are not using MIT Scheme. You are probably using 6.001 scheme.")
      (pp "This will cause your code to fail and you will get bad grades.")
      (pp "Use 'add scheme' to get your scheme instead of 'add 6.001'")
      (error))
    'ok)

(define (test-file root . tests)
  (load root)
  (map load (reverse tests))
  'done)

(define ps:test-score)
(define ps:max-score)
(define ps:test-id)

(define (begin-test-suite)
  (set! ps:test-id 0)
  (set! ps:max-score 0)
  (set! ps:test-score 0))

(define (end-test-suite)
  (pp `(testing complete: score ,ps:test-score of ,ps:max-score)))

;; this is the normal test: it just checks whether two answers
;; are identical
(define (test points question answer)
  (meta-test points question answer equal?))

;; when there are two or more valid answers to a question, this
;; test-function checks whether any of them are equal to the result
(define (multianswer-test points question answers)
  (meta-test points question answers
	     (lambda (a r) (reduce (lambda (x y) (or x y)) #f (map (lambda (x) (equal? x r)) a)))))

;; checks to see if two sets contain the same elements
(define (set-test points question answers)
  (meta-test points question answers equal-set?))

;; tests if two lists contain the same elements
(define (equal-set? a b)
  (define (helper a b) ;; assumes lists
    (if a
	(let* ((del-b (delete (car a) b))
	       (del-a (delete (car a) a)))
	  (if (= (length del-b) (length del-a))
	      (helper del-a del-b)
	      #f))
	#t))
  (and (list? a) (list? b) (= (length a) (length b)) (helper a b)))


;; for more complex checks for correctness, complex-test takes an
;; arbitrary lambda. This can be used, for example, in checking that
;; a function is no more than a certain length
(define (complex-test points question answer answer-function)
  (meta-test points question answer answer-function))

;; Some answers may want human inspection (god forbid)
;; This function prompts for an answer from the grader
(define (human-test points question answer)
  (meta-test 
   points question answer 
   (lambda (a r) 
     (pp (list "Expected:" a)) (pp (list "Actual:" r))
     (eq? (prompt-for-expression "Is this answer correct? (y/n)") 'y))))

;; the test function does a safe evaluation of the student's
;; function, then checks to see if it's the right answer
;; by applying the answer-function to the result and a prototype
;; correct answer. This function should not be called directly,
;; but rather should be called by one of the four models above
(define (meta-test points question answer answer-function)
  (set! ps:test-id (+ ps:test-id 1))
  (set! ps:max-score (+ ps:max-score points))
  (let* ((result (safe-eval question user-initial-environment))
	 (succeed (answer-function answer result)))
    (if succeed (set! ps:test-score (+ ps:test-score points)))
    (pp `((test case ,ps:test-id
	       ,(if succeed "ok" "FAIL") (,ps:test-score / ,ps:max-score))
	       (,question (expected ,answer) (result ,result))))
    succeed))

;; safe-eval is like eval, but when an error occurs
;; in the function being evaluated, it returns "error" rather
;; than allowing the error to halt execution
;; NOTE: if people prefer, this could return the precise error instead
(define (safe-eval expression environment)
  (let ((result (ignore-errors (lambda () (eval expression environment)))))
    (if (condition? result)
	'error ;; return that an error occurred
	result) ;; otherwise return the result
    ))
